#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27195);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: dazuko: Securityupdate to version 2.3.2 (dazuko-2404)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch dazuko-2404.

Description :

This patch updates the Dazuko kernel module to version
2.3.2. 

Several memory leaks and stability issues have been fixed.


Solution : 

Install the security patch dazuko-2404.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the dazuko-2404 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"dazuko-2.3.2-3.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"dazuko-kmp-bigsmp-2.3.2_2.6.18.2_34-3.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"dazuko-kmp-default-2.3.2_2.6.18.2_34-3.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"dazuko-kmp-xen-2.3.2_2.6.18.2_34-3.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
