#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29414);
 
 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for dhcp-server (dhcp-server-2437)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch dhcp-server-2437.

Description :

A bug was fixed were a LDAP server with malicious data
providing information to the DHCP server
 could crash and
potentially execute code as the DHCP server.


Solution : 

Install the security patch dhcp-server-2437.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the dhcp-server-2437 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"dhcp-server-3.0.3-23.10", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
