#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27200);
 script_cve_id("CVE-2006-2314");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: dovecot: Security Fix against potential SQL injection problems (dovecot-1987)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch dovecot-1987.

Description :

Dovecot might have been affected by the multibyte character
set SQL injection issues for instance described in
CVE-2006-2314.

This patch fixes the MySQL and PostgreSQL backend to use
the correct quoting methods when passing user supplied
strings.


Solution : 

Install the security patch dovecot-1987.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the dovecot-1987 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"dovecot-1.0.beta3-13.4", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
