#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27201);
 script_cve_id("CVE-2006-5973");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: dovecot: Securityfix for off-by-one overflow problem (dovecot-2306)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch dovecot-2306.

Description :

Off-by-one buffer overflow in Dovecot 1.0 versions, when
index files are used and mmap_disable is set to 'yes,'
allows remote authenticated IMAP or POP3 users to cause a
denial of service (crash) via unspecified vectors involving
the cache file. (CVE-2006-5973)


Solution : 

Install the security patch dovecot-2306.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the dovecot-2306 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"dovecot-1.0.beta3-13.6", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
