#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29415);
 script_cve_id("CVE-2007-5497");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for e2fsprogs (e2fsprogs-4743)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch e2fsprogs-4743.

Description :

This update of e2fsprogs fixes several integer overflows in
memory allocating code. Programs that use libext2fs are
therefore vulnerable to memory corruptions that can lead to
arbitrary code execution while loading a specially crafted
image. (CVE-2007-5497)


Solution : 

Install the security patch e2fsprogs-4743.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the e2fsprogs-4743 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"e2fsprogs-1.38-25.27", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"e2fsprogs-devel-1.38-25.27", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libcom_err-1.38-25.27", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"e2fsprogs-1.38-25.27", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"e2fsprogs-devel-1.38-25.27", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libcom_err-1.38-25.27", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
