#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27205);
 script_cve_id("CVE-2006-3627", "CVE-2006-3628", "CVE-2006-3632");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: ethereal security update (ethereal-1932)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch ethereal-1932.

Description :

This update fixes several security related bugs ranging
from crashes to arbitrary code execution. (CVE-2006-3627,
CVE-2006-3628, CVE-2006-3629, CVE-2006-3630, CVE-2006-3631,
CVE-2006-3632)


Solution : 

Install the security patch ethereal-1932.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the ethereal-1932 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"ethereal-0.10.14-16.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"ethereal-devel-0.10.14-16.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
