#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29421);
 script_cve_id("CVE-2007-3389", "CVE-2007-3390", "CVE-2007-3391", "CVE-2007-3392", "CVE-2007-3393");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for ethereal (ethereal-3888)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch ethereal-3888.

Description :

Various security problems were fixed in the wireshark
0.99.6 release, which were backported to ethereal
(predecessor of wireshark):

CVE-2007-3389: Wireshark allowed remote attackers to cause
a denial of service (crash) via a crafted chunked encoding
in an HTTP response, possibly related to a zero-length
payload.

CVE-2007-3390: Wireshark when running on certain systems,
allowed remote attackers to cause a denial of service
(crash) via crafted iSeries capture files that trigger a
SIGTRAP.

CVE-2007-3391: Wireshark allowed remote attackers to cause
a denial of service (memory consumption) via a malformed
DCP ETSI packet that triggers an infinite loop.

CVE-2007-3392: Wireshark allowed remote attackers to cause
a denial of service via malformed (1) SSL or (2) MMS
packets that trigger an infinite loop.

CVE-2007-3393: Off-by-one error in the DHCP/BOOTP dissector
in Wireshark allowed remote attackers to cause a denial of
service (crash) via crafted DHCP-over-DOCSIS packets.


Solution : 

Install the security patch ethereal-3888.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the ethereal-3888 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"ethereal-0.10.14-16.16", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"ethereal-devel-0.10.14-16.16", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"ethereal-0.10.14-16.16", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
