#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(30049);
 
 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: ethereal security update (ethereal-4849)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch ethereal-4849.

Description :

This update fixes several security bugs in ethereal that
can be used to crash the application and to possibly
execute arbitrary code remotely.


Solution : 

Install the security patch ethereal-4849.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the ethereal-4849 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"ethereal-0.10.14-16.21", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"ethereal-devel-0.10.14-16.21", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
