#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27212);
 script_cve_id("CVE-2006-3119", "CVE-2006-1695");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: fbi security update (fbi-1915)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch fbi-1915.

Description :

The fbgs program did not activate security options in the
postscript interpreter due to a typo (CVE-2006-3119). fbgs
also used a temporary directory with predictable name
(CVE-2006-1695).


Solution : 

Install the security patch fbi-1915.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the fbi-1915 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"fbi-2.03-17.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
