#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29425);
 script_cve_id("CVE-2005-4348", "CVE-2006-5867", "CVE-2006-5974");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for fetchmail (fetchmail-2608)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch fetchmail-2608.

Description :

Three security issues have been fixed in fetchmail:

CVE-2005-4348: fetchmail when configured for multidrop
mode, allows remote attackers to cause a denial of service
(application crash) by sending messages without headers
from upstream mail servers.

CVE-2006-5867: fetchmail did not properly enforce TLS and
may transmit cleartext passwords over unsecured links if
certain circumstances occur, which allows remote attackers
to obtain sensitive information via man-in-the-middle
(MITM) attacks.

CVE-2006-5974: fetchmail when refusing a message delivered
via the mda option, allowed remote attackers to cause a
denial of service (crash) via unknown vectors that trigger
a NULL pointer dereference when calling the ferror or
fflush functions.


Solution : 

Install the security patch fetchmail-2608.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the fetchmail-2608 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"fetchmail-6.3.2-15.8", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"fetchmail-6.3.2-15.8", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
