#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29427);
 script_cve_id("CVE-2007-1536");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for file (file-3034)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch file-3034.

Description :

An integer underflow within the ELF header parsing has been
fixed which could lead to arbitrary code execution.
CVE-2007-1536 has been assigned to this issue.


Solution : 

Install the security patch file-3034.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the file-3034 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"file-4.16-15.9", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"file-devel-4.16-15.9", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"file-4.16-15.9", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
