#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29431);
 script_cve_id("CVE-2007-4619");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for flac (flac-4569)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch flac-4569.

Description :

Multiple integer overflows in flac could potentially be
exploited by attackers via specially crafted files to
execute code in the context of the user opening the file
(CVE-2007-4619).


Solution : 

Install the security patch flac-4569.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the flac-4569 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"flac-1.1.2-15.7", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"flac-devel-1.1.2-15.7", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"flac-1.1.2-15.7", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"flac-devel-1.1.2-15.7", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
