#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29433);
 script_cve_id("CVE-2006-5330");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for flash-player (flash-player-2357)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch flash-player-2357.

Description :

This security update brings the Adobe Flash Player to
version 7.0.69. It
 fixes the following security problem:

CVE-2006-5330: CRLF injection vulnerability in Adobe Flash
Player
 allows remote attackers to modify HTTP headers of
client requests
 and conduct HTTP Request Splitting attacks
via CRLF sequences in
 arguments to the ActionScript
functions (1) XML.addRequestHeader and (2)
XML.contentType. NOTE: the flexibility of the attack varies
depending
 on the type of web browser being used.


Solution : 

Install the security patch flash-player-2357.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the flash-player-2357 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"flash-player-7.0.69.0-1.2", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
