#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29785);
 script_cve_id("CVE-2007-4324", "CVE-2007-5275", "CVE-2007-6245");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for flash-player (flash-player-4856)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch flash-player-4856.

Description :

This flash player update to version 9.0.115.0 fixes several
security problems. In the worst case an attacker could
potentially have flash-player execute arbitrary code via
specially crafted files. (CVE-2007-4324, CVE-2007-4768,
CVE-2007-5275, CVE-2007-6242, CVE-2007-6243, CVE-2007-6244,
CVE-2007-6245, CVE-2007-6246)

Note: Since Adobe doesn't support browsers other than
Firefox and Mozilla, this update doesn't work with browsers
such as Konqueror. Updates for konquerors are already in
the works.


Solution : 

Install the security patch flash-player-4856.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the flash-player-4856 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"flash-player-9.0.115.0-0.2", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
