#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29436);
 script_cve_id("CVE-2006-3467");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for freetype2 (freetype2-1918)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch freetype2-1918.

Description :

This security update fixes crashes in the PCF handling of
freetype2 which might be used to crash freetype2 using
applications or even to execude code in them.

This issue is tracked by the Mitre CVE ID CVE-2006-3467.


Solution : 

Install the security patch freetype2-1918.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the freetype2-1918 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"freetype2-2.1.10-18.8", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"freetype2-devel-2.1.10-18.8", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"freetype2-2.1.10-18.8", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"freetype2-devel-2.1.10-18.8", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
