#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27232);
 script_cve_id("CVE-2006-2452");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: GMD login configuration can be accessed without root privileges. (gdm-1582)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch gdm-1582.

Description :

This update solves a bug in GDM. This bug allows to bypass 
root authorization to access the login configuration. 
(CVE-2006-2452)


Solution : 

Install the security patch gdm-1582.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the gdm-1582 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"gdm-2.8.0.7-57.11", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
