#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29443);
 script_cve_id("CVE-2007-2949");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for gimp (gimp-3962)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch gimp-3962.

Description :

The image editor gimp was updated to fix a integer overflow
in the handling of PSD files. By providing a crafted PSD
file and tricking the user to open it an attacker could
execute code. (CVE-2007-2949)


Solution : 

Install the security patch gimp-3962.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the gimp-3962 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"gimp-2.2.10-22.27", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"gimp-devel-2.2.10-22.27", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
