#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27238);
 script_cve_id("CVE-2006-3404");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: gimp-unstable: Securityfix for XCF overflow problem (gimp-unstable-1919)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch gimp-unstable-1919.

Description :

A buffer overflow was fixed in the xcf loader in GIMP that
allows user-complicit attackers to cause a denial of
service (crash) and possibly execute arbitrary code via an
XCF file with a large num_axes value in the VECTORS
property. (CVE-2006-3404)


Solution : 

Install the security patch gimp-unstable-1919.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the gimp-unstable-1919 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"gimp-unstable-2.3.7-17.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
