#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27244);
 script_cve_id("CVE-2006-3082");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: gpg: Security update to fix crash on special crafted messages (gpg-1664)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch gpg-1664.

Description :

It is possible to crash (denial of service) the GNU Privacy 
Guard (gpg) by supplying a specifically crafted message 
specifying a very large UID, which leads to an out of 
memory situation or an integer overflow.  It is unclear if 
this problem can be exploited to execute code.  This issue 
is tracked by the Mitre CVE ID CVE-2006-3082.


Solution : 

Install the security patch gpg-1664.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the gpg-1664 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"gpg-1.4.2-23.4", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
