#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29449);
 script_cve_id("CVE-2006-6169", "CVE-2006-6235");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for gpg (gpg-2355)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch gpg-2355.

Description :

- Specially crafted files could overflow a buffer when gpg2
  was used
 in interactive mode (CVE-2006-6169).
- Specially crafted files could modify a function pointer
  and
 execute code this way (CVE-2006-6235).


Solution : 

Install the security patch gpg-2355.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the gpg-2355 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"gpg-1.4.2-23.12", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"gpg-1.4.2-23.12", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
