#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27248);
 script_cve_id("CVE-2007-1263");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: gpg: Fixed mixed signed/unsigned text problem (gpg-2995)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch gpg-2995.

Description :

When printing a text stream with a GPG signature it was
possible for an attacker to create a stream with 'unsigned
text, signed text' where both unsigned and signed text
would be shown without distinction which one was signed and
which part wasn't.

This is tracked by the Mitre CVE ID CVE-2007-1263.

The update introduces a new option
--allow-multiple-messages to print out such messages in the
future, by default it only prints and handles the first one.


Solution : 

Install the security patch gpg-2995.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the gpg-2995 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"gpg-1.4.2-23.16", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"gpg-1.4.5-24.4", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
