#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27256);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: gv: Additional fix for previous security update (gv-2338)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch gv-2338.

Description :

The previous 'gv' update to fix a stack overflow did not
completely fix the problem spotted. An attacker could still
cause the handling to use up all system memory, or open
windows much wider than the X display and crash. Code
execution however was not possible.


Solution : 

Install the security patch gv-2338.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the gv-2338 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"gv-3.5.8-1156.8", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
