#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27258);
 script_cve_id("CVE-2007-2953");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: vim: This update of Vim addresses a format-string bug in 'helptags' (CVE-2007-2953) (gvim-4092)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch gvim-4092.

Description :

This update of Vim addresses a format-string bug in
'helptags'. This bug can be exploited to execute code with
the privileges of the user running Vim. (CVE-2007-2953)


Solution : 

Install the security patch gvim-4092.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the gvim-4092 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"gvim-6.4.6-19.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"vim-6.4.6-19.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"gvim-7.0-38", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"vim-7.0-38", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"vim-enhanced-7.0-38", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
