#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27261);
 script_cve_id("CVE-2006-4334");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: gzip: Security update (gzip-2084)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch gzip-2084.

Description :

This update fixes several security problems that can be
exploited to compromise the system in conjunction with
other programs while processing malformated archive files.
(CVE-2006-4334,CVE-2006-4335,CVE-2006-4336,CVE-2006-4337,CVE
-2006-4338)


Solution : 

Install the security patch gzip-2084.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the gzip-2084 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"gzip-1.3.5-159.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
