#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27265);
 script_cve_id("CVE-2006-3548", "CVE-2006-3549");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: horde: Securityfixes for cross site scripting problems. (horde-1868)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch horde-1868.

Description :

This update fixes the following two security issues in the
Horde Application Framework:
- CVE-2006-3548: Multiple cross-site scripting (XSS)
  vulnerabilities allow remote attackers to inject
  arbitrary web script or HTML via a (1) javascript URI or
  an external (2) http, (3) https, or (4) ftp URI in the
  url parameter in services/go.php (aka the dereferrer),
  (5) a javascript URI in the module parameter in
  services/help (aka the help viewer), and (6) the name
  parameter in services/problem.php (aka the problem
  reporting screen).

- CVE-2006-3549: services/go.php does not properly restrict
  its image proxy capability, which allows remote attackers
  to perform 'Web tunneling' attacks and use the server as
  a proxy via (1) http, (2) https, and (3) ftp URL in the
  url parameter, which is requested from the server.


Solution : 

Install the security patch horde-1868.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the horde-1868 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"horde-3.0.9-19.4", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
