#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29461);
 script_cve_id("CVE-2007-6110");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for htdig (htdig-4761)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch htdig-4761.

Description :

A flaw in the htsearch Program could be exploited by
attackers to conduct cross site scripting (XSS) attacks
(CVE-2007-6110).


Solution : 

Install the security patch htdig-4761.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the htdig-4761 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"htdig-3.2.0b6-21.6", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"htdig-3.2.0b6-21.6", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
