#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27269);
 script_cve_id("CVE-2007-4460");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: id3lib: This update fixes a bug that allows local attackers to overwrite arbitrary files. (id3lib-4316)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch id3lib-4316.

Description :

This update fixes a bug that allows local attackers to
overwrite arbitrary files. (CVE-2007-4460)


Solution : 

Install the security patch id3lib-4316.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the id3lib-4316 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"id3lib-3.8.3-104.7", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"id3lib-devel-3.8.3-104.7", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"id3lib-examples-3.8.3-104.7", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"id3lib-3.8.3-126", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"id3lib-devel-3.8.3-126", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"id3lib-examples-3.8.3-126", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
