#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29465);
 script_cve_id("CVE-2007-1463", "CVE-2007-1464");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for inkscape (inkscape-3061)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch inkscape-3061.

Description :

Several format string problems where fixed in inkscape.

CVE-2007-1463: A format string vulnerability in Inkscape
allows user-assisted remote attackers to execute arbitrary
code via format string specifiers in a URI, which is not
properly handled by certain dialogs.

CVE-2007-1464: Format string vulnerability in the
whiteboard Jabber protocol in Inkscape allows user-assisted
remote attackers to execute arbitrary code via unspecified
vectors.


Solution : 

Install the security patch inkscape-3061.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the inkscape-3061 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"inkscape-0.43-20.5.3", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
