#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29469);
 script_cve_id("CVE-2007-0243", "CVE-2006-6737", "CVE-2006-6745");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for IBM Java (java-1_4_2-ibm-3851)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch java-1_4_2-ibm-3851.

Description :

The IBM Java JRE/SDK has been brought to release 1.4.2 SR
containing several bugfixes, including following security
fixes:

CVE-2007-0243: A buffer overflow vulnerability in the
Java(TM) Runtime Environment may allow an untrusted applet
to elevate its privileges. For example, an applet may grant
itself permissions to read and write local files or execute
local applications that are accessible to the user running
the untrusted applet.

CVE-2006-6737/CVE-2006-6736: Two vulnerabilities in the
Java Runtime Environment may independently allow an
untrusted applet to access data in other applets.

CVE-2006-6745: Two vulnerabilities in the Java(TM) Runtime
Environment with serialization may independently allow an
untrusted applet or application to elevate its privileges.


Solution : 

Install the security patch java-1_4_2-ibm-3851.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the java-1_4_2-ibm-3851 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"java-1_4_2-ibm-1.4.2_sr8-1.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_4_2-ibm-devel-1.4.2_sr8-1.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_4_2-ibm-jdbc-1.4.2_sr8-1.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_4_2-ibm-plugin-1.4.2_sr8-1.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
