#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29470);
 script_cve_id("CVE-2007-2788", "CVE-2007-3655", "CVE-2007-3922");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for IBM Java 1.4.2 (java-1_4_2-ibm-4542)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch java-1_4_2-ibm-4542.

Description :

The IBM Java JRE/SDK has been brought to release 1.4.2 SR9,
containing several bugfixes, including the following
security fixes:

- CVE-2007-2788,CVE-2007-2789,CVE-2007-3004,CVE-2007-3005:
  A buffer overflow vulnerability in the image parsing code
  in the Java(TM) Runtime Environment may allow an
  untrusted applet or application to elevate its
  privileges. For example, an applet may grant itself
  permissions to read and write local files or execute
  local applications that are accessible to the user
  running the untrusted applet.

  A second vulnerability may allow an untrusted applet or
application to cause the Java Virtual Machine to hang.

- CVE-2007-3655: A buffer overflow vulnerability in the
  Java Web Start URL parsing code may allow an untrusted
  application to elevate its privileges. For example, an
  application may grant itself permissions to read and
  write local files or execute local applications with the
  privileges of the user running the Java Web Start
  application.

- CVE-2007-3922: A security vulnerability in the Java
  Runtime Environment Applet Class Loader may allow an
  untrusted applet that is loaded from a remote system to
  circumvent network access restrictions and establish
  socket connections to certain services running on the
  local host, as if it were loaded from the system that the
  applet is running on. This may allow the untrusted remote
  applet the ability to exploit any security
  vulnerabilities existing in the services it has connected
  to.

For more information see:
http://www-128.ibm.com/developerworks/java/jdk/alerts/


Solution : 

Install the security patch java-1_4_2-ibm-4542.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the java-1_4_2-ibm-4542 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"java-1_4_2-ibm-1.4.2_sr9-0.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_4_2-ibm-devel-1.4.2_sr9-0.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_4_2-ibm-jdbc-1.4.2_sr9-0.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_4_2-ibm-plugin-1.4.2_sr9-0.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
