#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27277);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: java: Missing SUN Java packages 1.4.2 update 13 and 1.5.0 update 10 (java-1_4_2-sun-demo-2469)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch java-1_4_2-sun-demo-2469.

Description :

The SUN Java packages have been upgraded to 1.4.2 update 13
and 1.5.0 update 10 to fix various security problems, this
update contains the missing packages that were left out for
10.2.


Solution : 

Install the security patch java-1_4_2-sun-demo-2469.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the java-1_4_2-sun-demo-2469 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"java-1_4_2-sun-demo-1.4.2_update13-3.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_4_2-sun-src-1.4.2_update13-3.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_5_0-sun-demo-1.5.0_update10-2.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_5_0-sun-src-1.5.0_update10-2.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
