#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27285);
 script_cve_id("CVE-2006-2449");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: kdm security update (kdebase3-kdm-1609)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch kdebase3-kdm-1609.

Description :

KDM stores the type of the previously used session in the 
user's home directory. By using a symlink users could trick 
kdm into also storing content of files that are normally 
not accesible by users (CVE-2006-2449).


Solution : 

Install the security patch kdebase3-kdm-1609.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the kdebase3-kdm-1609 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"kdebase3-kdm-3.5.1-69.23", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
