#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29478);
 
 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for kdegraphics3 (kdegraphics3-2301)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch kdegraphics3-2301.

Description :

The KFILE JPEG plugin that is responsible for displaying
meta-data of JPEG files was affected by some old common
vulnerabilities in EXIF handling.

A JPEG file could be prepapred with an EXIF section with
endless recursion that would overflow the stack and cause
the plugin and so the image browser (konqueror, digikam or
other kfile users) to crash.


Solution : 

Install the security patch kdegraphics3-2301.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the kdegraphics3-2301 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"kdegraphics3-3.5.1-23.9", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kdegraphics3-3.5.1-23.9", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
