#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29479);
 script_cve_id("CVE-2007-0104");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for kdegraphics3-pdf (kdegraphics3-pdf-2564)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch kdegraphics3-pdf-2564.

Description :

This update fixes a vulnerability which occurs while
processing a special PDF file. This bug can lead to a
denial-of-service condition, or a memory corruption, or to
arbitrary code execution. (CVE-2007-0104)


Solution : 

Install the security patch kdegraphics3-pdf-2564.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the kdegraphics3-pdf-2564 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"kdegraphics3-pdf-3.5.1-23.13", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kdegraphics3-pdf-3.5.1-23.13", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
