#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29483);
 script_cve_id("CVE-2007-1564");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for kdelibs3,kdelibs3-devel,CVE-2007-1564 (kdelibs3-3988)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch kdelibs3-3988.

Description :

A bug in konqueror allowed attackers to abuse the FTP
passive mode for portscans (CVE-2007-1564).


Solution : 

Install the security patch kdelibs3-3988.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the kdelibs3-3988 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"kdelibs3-3.5.1-49.38", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kdelibs3-devel-3.5.1-49.38", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kdelibs3-3.5.1-49.38", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kdelibs3-devel-3.5.1-49.38", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
