#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29786);
 
 script_version ("$Revision: 1.2 $");

 name["english"] = "SuSE Security Update: klamav security update (klamav-4837)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch klamav-4837.

Description :

clamav has been updated due to security problem. The
version number of the clamav library has been changed with
that update. Therefore programs like klamav that are linked
against libclamav need to be updated as well.


Solution : 

Install the security patch klamav-4837.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the klamav-4837 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"klamav-0.41.1-17.2", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"klamav-0.41.1-32.1", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
