#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27304);
 script_cve_id("CVE-2006-6120");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: koffice: Securityfix for bufferoverflow in OLE importer. (koffice-2323)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch koffice-2323.

Description :

This update fixes a security problem in the OLE import
handling for PPT files, where attackers with crafted
documents could crash kpresenter and potentially execute
code. (CVE-2006-6120)


Solution : 

Install the security patch koffice-2323.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the koffice-2323 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"koffice-1.4.2-25.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
