#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29959);
 script_cve_id("CVE-2007-6352");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: libexif5: Fixes a security problem in the EXIF loader. (libexif5-4882)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch libexif5-4882.

Description :

One bug in libexif5 was identified by a Google Security
Audit done by Meder Kydyraliev.

CVE-2007-6352: Integer overflows in the thumbnail handler
could be used to overflow buffers and potentially execute
code or crash a program using libexif.


Solution : 

Install the security patch libexif5-4882.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the libexif5-4882 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"libexif5-0.5.12-17.10", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libexif5-0.5.12-41", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libexif5-0.5.12-80.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
