#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29504);
 script_cve_id("CVE-2007-2741");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for liblcms,liblcms-devel (liblcms-4626)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch liblcms-4626.

Description :

This update addresses security bugs in liblcms that
occurred while parsing ICC profiles in JPEG images.
(CVE-2007-2741) Remote attackers can exploit this bug to
execute arbitrary commands or cause denial-of-service.


Solution : 

Install the security patch liblcms-4626.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the liblcms-4626 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"liblcms-1.15-12.6", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"liblcms-devel-1.15-12.6", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"liblcms-1.15-12.6", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"liblcms-devel-1.15-12.6", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
