#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29510);
 script_cve_id("CVE-2007-3999");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for librpcsecgss (librpcsecgss-4601)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch librpcsecgss-4601.

Description :

This update fixes a security problem in the librpcsecgss
library used by NFSv4 also found in krb5. A invalid packet
could underflow and potentially cause memory corruption and
code execution.  (CVE-2007-3999)


Solution : 

Install the security patch librpcsecgss-4601.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the librpcsecgss-4601 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"librpcsecgss-0.7-13.8", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"librpcsecgss-0.7-13.8", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
