#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29851);
 script_cve_id("CVE-2007-4974");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for libsndfile (libsndfile-4431)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch libsndfile-4431.

Description :

This update fixes a possible buffer overflow that occurs
while reading decoded PCM data from the FLAC library.
(CVE-2007-4974)


Solution : 

Install the security patch libsndfile-4431.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the libsndfile-4431 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"libsndfile-1.0.12-13.7", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libsndfile-devel-1.0.12-13.7", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libsndfile-1.0.12-13.7", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libsndfile-devel-1.0.12-13.7", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
