#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27339);
 script_cve_id("CVE-2007-1869");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: lighttpd security update (lighttpd-3090)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch lighttpd-3090.

Description :

Two remotely exploitable DoS vulnerabilities in lighttpd
can be used to crash lighttpd or make it waste CPU time in
an enless loop (CVE-2007-1869, CVE-2007-1870).


Solution : 

Install the security patch lighttpd-3090.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the lighttpd-3090 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"lighttpd-1.4.10-11.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"lighttpd-1.4.13-41.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
