#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27342);
 script_cve_id("CVE-2006-5925");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: links security update (links-2292)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch links-2292.

Description :

Malicious web sites could abuse smb:// URLs to read or
write
 arbitrary files of the user (CVE-2006-5925).
Therefore this update
 disables SMB support in links.


Solution : 

Install the security patch links-2292.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the links-2292 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"links-2.1pre18-14.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
