#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27343);
 script_cve_id("CVE-2006-0743");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: log4net: Securityfix for formatstring exploit (log4net-2211)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch log4net-2211.

Description :

This update fixes a format string exploit in the
RemoteSyslogAppender of log4net. CVE-2006-0743


Solution : 

Install the security patch log4net-2211.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the log4net-2211 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"log4net-1.2.9-17.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
