#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27356);
 script_cve_id("CVE-2006-1516", "CVE-2006-1518");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: mysql security update (mysql-1312)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch mysql-1312.

Description :

Attackers could read portions of memory by using a user 
name with trailing null byte or via COM_TABLE_DUMP command 
(CVE-2006-1516, CVE-2006-1517).  Attackers could execute 
arbitrary code by causing a buffer overflow via specially 
crafted COM_TABLE_DUMP packets (CVE-2006-1518).


Solution : 

Install the security patch mysql-1312.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the mysql-1312 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"mysql-5.0.18-16.1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
