#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27358);
 script_cve_id("CVE-2006-4031");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: mysql: This update fixes several security vulnerabilities (mysql-2075)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch mysql-2075.

Description :

This update of mysql fixes several security
vulnerabilities. (CVE-2006-4031,CVE-2006-4226,CVE-2006-4227)


Solution : 

Install the security patch mysql-2075.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the mysql-2075 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"mysql-5.0.18-20.8", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"mysql-Max-5.0.18-20.8", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
