#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27361);
 script_cve_id("CVE-2007-0157");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: neon: This update fixes a possible crash in the URI parser. (neon-2476)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch neon-2476.

Description :

Fix for incorrect array index handling with non-ASCII
characters in the URI parser. (CVE-2007-0157)


Solution : 

Install the security patch neon-2476.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the neon-2476 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"neon-0.26.1-26.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"neon-32bit-0.26.1-26.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"neon-64bit-0.26.1-26.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
