#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29882);
 script_cve_id("CVE-2007-5846");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: net-snmp: Fix for denial-of-service. (net-snmp-4753)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch net-snmp-4753.

Description :

This update of net-snmp fixes the following bugs: 
- default and configurable maximum number of varbinds
  returnable to  a GETBULK request (CVE-2007-5846) 
- crash when smux peers were configured with empty
  passwords 
- the UCD-SNMP-MIB::memCached.0 SNMP object was missing 
- the snmptrap command from the net-snmp package sends
  traps per default on the wrong port.


Solution : 

Install the security patch net-snmp-4753.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the net-snmp-4753 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"net-snmp-5.4.rc2-6", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"net-snmp-32bit-5.4.rc2-6", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"net-snmp-64bit-5.4.rc2-6", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"net-snmp-devel-5.4.rc2-6", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"net-snmp-devel-64bit-5.4.rc2-6", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"perl-SNMP-5.4.rc2-6", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
