#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29528);
 script_cve_id("CVE-2007-5846");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for net-snmp (net-snmp-4755)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch net-snmp-4755.

Description :

This update of net-snmp fixes the following bug: 
- default and configurable maximum number of varbinds
  returnable to  a GETBULK request (CVE-2007-5846) 
- crash when smux peers were configured with empty passwords


Solution : 

Install the security patch net-snmp-4755.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the net-snmp-4755 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"net-snmp-5.3.0.1-25.22", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"net-snmp-devel-5.3.0.1-25.22", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"perl-SNMP-5.3.0.1-25.22", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"net-snmp-5.3.0.1-25.22", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"net-snmp-devel-5.3.0.1-25.22", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"perl-SNMP-5.3.0.1-25.22", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
