#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(30016);
 script_cve_id("CVE-2007-1841");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: novell-ipsec-tools: Security update (novell-ipsec-tools-4655)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch novell-ipsec-tools-4655.

Description :

This update fixes a security problem in novell-ipsec-tools:

CVE-2007-1841: Fix a DoS in isakmp_info_recv

and also a non-security bug with a crash in GSSAPI.


Solution : 

Install the security patch novell-ipsec-tools-4655.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the novell-ipsec-tools-4655 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"novell-ipsec-tools-0.6.3-114.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"novell-ipsec-tools-devel-0.6.3-114.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
